#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
This experiment was created using PsychoPy2 Experiment Builder (v1.70.00), November 12, 2014, at 13:10
If you publish work using this script please cite the relevant PsychoPy publications
  Peirce, JW (2007) PsychoPy - Psychophysics software in Python. Journal of Neuroscience Methods, 162(1-2), 8-13.
  Peirce, JW (2009) Generating stimuli for neuroscience using PsychoPy. Frontiers in Neuroinformatics, 2:10. doi: 10.3389/neuro.11.010.2008
"""
import numpy as np  # whole numpy lib is available, pre-pend 'np.'
from numpy import sin, cos, tan, log, log10, pi, average, sqrt, std, deg2rad, rad2deg, linspace, asarray
from numpy.random import random, randint, normal, shuffle
import os #handy system and path functions
from psychopy import core, data, event, visual, gui
import psychopy.log #import like this so it doesn't interfere with numpy.log
from psychopy.constants import *

#store info about the experiment session
expName='None'#from the Builder filename that created this script
expInfo={'participant':'', 'session':'001'}
dlg=gui.DlgFromDict(dictionary=expInfo,title=expName)
if dlg.OK==False: core.quit() #user pressed cancel
expInfo['date']=data.getDateStr()#add a simple timestamp
expInfo['expName']=expName
#setup files for saving
if not os.path.isdir('data'):
    os.makedirs('data') #if this fails (e.g. permissions) we will get error
filename='data' + os.path.sep + '%s_%s' %(expInfo['participant'], expInfo['date'])
psychopy.log.console.setLevel(psychopy.log.WARNING)#this outputs to the screen, not a file
logFile=psychopy.log.LogFile(filename+'.log', level=psychopy.log.EXP)

#setup the Window
win = visual.Window(size=(1680, 1050), fullscr=True, screen=0, allowGUI=False, allowStencil=False,
    monitor='testMonitor', color=[0,0,0], colorSpace='rgb')

#Initialise components for routine:istruzioni_
istruzioni_Clock=core.Clock()
text=visual.TextStim(win=win, ori=0, name='text',
    text=u"scegli la freccia sinistra se l'immagine che preferisci \xe8 quella di sinistra, la freccia a destra se l'immagine che preferisci \xe8 quella di destra ",
    font='Arial',
    pos=[0, 0], height=0.1,
    color='white', colorSpace='rgb')

#set up handler to look after randomisation of conditions etc
trials=data.TrialHandler(nReps=2, method=u'random', 
    extraInfo=expInfo, originPath='/Users/margheritabracci/Desktop/esperimento fiori/esperimento2.psyexp',
    trialList=data.importConditions('../esperimento fiori/condizio.xlsx'))
thisTrial=trials.trialList[0]#so we can initialise stimuli with some values
#abbreviate parameter names if possible (e.g. rgb=thisTrial.rgb)
if thisTrial!=None:
    for paramName in thisTrial.keys():
        exec(paramName+'=thisTrial.'+paramName)

#Initialise components for routine:trial
trialClock=core.Clock()
immagineSn=visual.PatchStim(win=win, name='immagineSn',units='cm', 
    tex='sin', mask='None',
    ori=0, pos=[-10, 0], size=1.0, sf=None, phase=0.0,
    color=[1,1,1], colorSpace='rgb',
    texRes=128, interpolate=False)
immagineDs=visual.PatchStim(win=win, name='immagineDs',units='cm', 
    tex='sin', mask='None',
    ori=0, pos=[10, 0], size=1.0, sf=None, phase=0.0,
    color=[1,1,1], colorSpace='rgb',
    texRes=128, interpolate=False)

#Initialise components for routine:ringraziamenti
ringraziamentiClock=core.Clock()
text_2=visual.TextStim(win=win, ori=0, name='text_2',
    text=u"L'esperimento \xe8 finito \nGrazie! ",
    font='Arial',
    pos=[0, 0], height=0.1,
    color='white', colorSpace='rgb')

#Start of routine istruzioni_
t=0; istruzioni_Clock.reset()
frameN=-1

#update component parameters for each repeat
key_resp_2 = event.BuilderKeyResponse() #create an object of type KeyResponse
key_resp_2.status=NOT_STARTED
#keep track of which have finished
istruzioni_Components=[]#to keep track of which have finished
istruzioni_Components.append(text)
istruzioni_Components.append(key_resp_2)
for thisComponent in istruzioni_Components:
    if hasattr(thisComponent,'status'): thisComponent.status = NOT_STARTED
#start the Routine
continueRoutine=True
while continueRoutine:
    #get current time
    t=istruzioni_Clock.getTime()
    frameN=frameN+1#number of completed frames (so 0 in first frame)
    #update/draw components on each frame
    
    #*text* updates
    if t>=0.0 and text.status==NOT_STARTED:
        #keep track of start time/frame for later
        text.tStart=t#underestimates by a little under one frame
        text.frameNStart=frameN#exact frame index
        text.setAutoDraw(True)
    
    #*key_resp_2* updates
    if t>=0.0 and key_resp_2.status==NOT_STARTED:
        #keep track of start time/frame for later
        key_resp_2.tStart=t#underestimates by a little under one frame
        key_resp_2.frameNStart=frameN#exact frame index
        key_resp_2.status=STARTED
        #keyboard checking is just starting
        key_resp_2.clock.reset() # now t=0
        event.clearEvents()
    if key_resp_2.status==STARTED:#only update if being drawn
        theseKeys = event.getKeys()
        if len(theseKeys)>0:#at least one key was pressed
            key_resp_2.keys=theseKeys[-1]#just the last key pressed
            key_resp_2.rt = key_resp_2.clock.getTime()
            #was this 'correct'?
            if (key_resp_2.keys==str('corrAns')): key_resp_2.corr=1
            else: key_resp_2.corr=0
            #abort routine on response
            continueRoutine=False
    
    #check if all components have finished
    if not continueRoutine:
        break # lets a component forceEndRoutine
    continueRoutine=False#will revert to True if at least one component still running
    for thisComponent in istruzioni_Components:
        if hasattr(thisComponent,"status") and thisComponent.status!=FINISHED:
            continueRoutine=True; break#at least one component has not yet finished
    
    #check for quit (the [Esc] key)
    if event.getKeys(["escape"]): core.quit()
    #refresh the screen
    if continueRoutine:#don't flip if this routine is over or we'll get a blank screen
        win.flip()

#end of routine istruzioni_
for thisComponent in istruzioni_Components:
    if hasattr(thisComponent,"setAutoDraw"): thisComponent.setAutoDraw(False)

for thisTrial in trials:
    currentLoop = trials
    #abbrieviate parameter names if possible (e.g. rgb=thisTrial.rgb)
    if thisTrial!=None:
        for paramName in thisTrial.keys():
            exec(paramName+'=thisTrial.'+paramName)
    
    #Start of routine trial
    t=0; trialClock.reset()
    frameN=-1
    
    #update component parameters for each repeat
    immagineSn.setTex(sinistra)
    immagineSn.setSize(5)
    immagineDs.setTex(destra)
    immagineDs.setSize(5)
    key_resp = event.BuilderKeyResponse() #create an object of type KeyResponse
    key_resp.status=NOT_STARTED
    #keep track of which have finished
    trialComponents=[]#to keep track of which have finished
    trialComponents.append(immagineSn)
    trialComponents.append(immagineDs)
    trialComponents.append(key_resp)
    for thisComponent in trialComponents:
        if hasattr(thisComponent,'status'): thisComponent.status = NOT_STARTED
    #start the Routine
    continueRoutine=True
    while continueRoutine:
        #get current time
        t=trialClock.getTime()
        frameN=frameN+1#number of completed frames (so 0 in first frame)
        #update/draw components on each frame
        
        #*immagineSn* updates
        if t>=0.0 and immagineSn.status==NOT_STARTED:
            #keep track of start time/frame for later
            immagineSn.tStart=t#underestimates by a little under one frame
            immagineSn.frameNStart=frameN#exact frame index
            immagineSn.setAutoDraw(True)
        
        #*immagineDs* updates
        if t>=0.0 and immagineDs.status==NOT_STARTED:
            #keep track of start time/frame for later
            immagineDs.tStart=t#underestimates by a little under one frame
            immagineDs.frameNStart=frameN#exact frame index
            immagineDs.setAutoDraw(True)
        
        #*key_resp* updates
        if t>=0.1 and key_resp.status==NOT_STARTED:
            #keep track of start time/frame for later
            key_resp.tStart=t#underestimates by a little under one frame
            key_resp.frameNStart=frameN#exact frame index
            key_resp.status=STARTED
            #keyboard checking is just starting
            key_resp.clock.reset() # now t=0
            event.clearEvents()
        if key_resp.status==STARTED:#only update if being drawn
            theseKeys = event.getKeys(keyList=['left', 'right'])
            if len(theseKeys)>0:#at least one key was pressed
                key_resp.keys=theseKeys[-1]#just the last key pressed
                key_resp.rt = key_resp.clock.getTime()
                #was this 'correct'?
                if (key_resp.keys==str('corr')): key_resp.corr=1
                else: key_resp.corr=0
                #abort routine on response
                continueRoutine=False
        
        #check if all components have finished
        if not continueRoutine:
            break # lets a component forceEndRoutine
        continueRoutine=False#will revert to True if at least one component still running
        for thisComponent in trialComponents:
            if hasattr(thisComponent,"status") and thisComponent.status!=FINISHED:
                continueRoutine=True; break#at least one component has not yet finished
        
        #check for quit (the [Esc] key)
        if event.getKeys(["escape"]): core.quit()
        #refresh the screen
        if continueRoutine:#don't flip if this routine is over or we'll get a blank screen
            win.flip()
    
    #end of routine trial
    for thisComponent in trialComponents:
        if hasattr(thisComponent,"setAutoDraw"): thisComponent.setAutoDraw(False)
    #check responses
    if len(key_resp.keys)==0: #No response was made
       key_resp.keys=None
       #was no response the correct answer?!
       if str('corr').lower()=='none':key_resp.corr=1 #correct non-response
       else: key_resp.corr=0 #failed to respond (incorrectly)
    #store data for trials (TrialHandler)
    trials.addData('key_resp.keys',key_resp.keys)
    trials.addData('key_resp.corr',key_resp.corr)
    if key_resp.keys != None:#we had a response
        trials.addData('key_resp.rt',key_resp.rt)

#completed 2 repeats of 'trials'

trials.saveAsPickle(filename+'trials')
trials.saveAsExcel(filename+'.xlsx', sheetName='trials',
    stimOut=['corrAns', 'destra', 'sinistra', ],
    dataOut=['n','all_mean','all_std', 'all_raw'])

#Start of routine ringraziamenti
t=0; ringraziamentiClock.reset()
frameN=-1

#update component parameters for each repeat
#keep track of which have finished
ringraziamentiComponents=[]#to keep track of which have finished
ringraziamentiComponents.append(text_2)
for thisComponent in ringraziamentiComponents:
    if hasattr(thisComponent,'status'): thisComponent.status = NOT_STARTED
#start the Routine
continueRoutine=True
while continueRoutine:
    #get current time
    t=ringraziamentiClock.getTime()
    frameN=frameN+1#number of completed frames (so 0 in first frame)
    #update/draw components on each frame
    
    #*text_2* updates
    if t>=0.0 and text_2.status==NOT_STARTED:
        #keep track of start time/frame for later
        text_2.tStart=t#underestimates by a little under one frame
        text_2.frameNStart=frameN#exact frame index
        text_2.setAutoDraw(True)
    elif text_2.status==STARTED and t>=(0.0+1.0):
        text_2.setAutoDraw(False)
    
    #check if all components have finished
    if not continueRoutine:
        break # lets a component forceEndRoutine
    continueRoutine=False#will revert to True if at least one component still running
    for thisComponent in ringraziamentiComponents:
        if hasattr(thisComponent,"status") and thisComponent.status!=FINISHED:
            continueRoutine=True; break#at least one component has not yet finished
    
    #check for quit (the [Esc] key)
    if event.getKeys(["escape"]): core.quit()
    #refresh the screen
    if continueRoutine:#don't flip if this routine is over or we'll get a blank screen
        win.flip()

#end of routine ringraziamenti
for thisComponent in ringraziamentiComponents:
    if hasattr(thisComponent,"setAutoDraw"): thisComponent.setAutoDraw(False)

#Shutting down:
win.close()
core.quit()
